define([
    'underscore',
    'backbone',
    'marionette',
    'modules/form/section-view',
    'json!modules/community-care-request/new-appointment-request-question/preferred-provider/preferences/preferred-provider.json', // eslint-disable-line max-len
],
function(
    _,
    Backbone,
    Marionette,
    SectionView,
    metadata
) {
    'use strict';
    return SectionView.extend({
        initialize: function(options) {
            var sectionName = 'primary-care-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata) || new Backbone.Collection();
            // initialize listener to 'change:value' after static values are set
            this.newValues = this.getOfficeHoursNeeded();
            this.collection.get('officeHours').set('values', this.newValues);
            this.initializeQuestionEventListeners();
        },
        getOfficeHoursNeeded: function() {
            var newValues = [];
            var officeHours = this.model.get('officeHours');
            _.each(this.collection.get('officeHours').get('values'), function (valueObj) {
                var key;
                var time;
                valueObj.selected = false;
                if (officeHours) {
                    for (key in officeHours) {
                        if (officeHours.hasOwnProperty(key)) {
                            time = officeHours[key];
                            if (time === valueObj.value) {
                                valueObj.selected = true;
                            }
                        }
                    }
                }
                newValues.push(valueObj);
            });
            return newValues;
        },
        updateFDNS   el: function (model) {
            var id = model.get('id');
            var val = model.get('value');
            var selected;
            var timesToComeIn;
            if (id === 'officeHours') {
                selected = model.get('selected');
                if (!Array.isArray(selected)) {
                    timesToComeIn = selected ?
                        _.union(this.model.get('officeHours'), [val]) :
                        _.without(this.model.get('officeHours'), val);
                    this.model.set(id, timesToComeIn);
                }
            } else {
                this.model.set(id, val);
            }
        },
    });
});
